<?php

namespace Albedo\Gamification\Exceptions;

use Albedo\LogAlert\Services\LogAlert;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Throwable;

class GamificationExceptionHandler extends ExceptionHandler
{
    public function report(Throwable $e)
    {
        parent::report($e);

        if (! $this->shouldReport($e)) {
            return;
        }

        $level = match (true) {
            $e instanceof ModelNotFoundException,
            $e instanceof NotFoundHttpException => 'warning',
            $e instanceof \Exception && $e->getCode() >= 500 => 'critical',
            $e instanceof \Exception && $e->getCode() >= 400 => 'error',
            default => 'default'
        };

        $meta = [
            'url' => request()?->fullUrl(),
            'ip'  => request()?->ip(),
            'user' => optional(auth()->user())->id,
        ];

        match ($level) {
            'critical' => LogAlert::criticalBackend($e, json_encode($meta)),
            'error'    => LogAlert::midBackend($e, json_encode($meta)),
            'warning'  => LogAlert::lowBackend($e, json_encode($meta)),
            default    => LogAlert::midBackend($e, json_encode($meta)),
        };
    }
}
