<?php

namespace Albedo\Gamification\Http\Controllers;


use Albedo\Gamification\Http\Requests\UpdateAvatarRequest;
use Albedo\Gamification\Models\Avatar;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;

class UpdateAvatarAction extends Controller
{
    public function __invoke(UpdateAvatarRequest $request)
    {
        $user = auth()->user();
        $avatarId = $request->input('avatar_id');

        $user->avatars()->sync([$avatarId]);

        return Response::success('Avatar has been updated');
    }
}
