<?php

namespace Albedo\Gamification\Http\Controllers;

use Albedo\Gamification\Settings\ModuleSettings;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;

/**
 * Pobierz statusy poszczególnych modułów.
 *
 * Endpoint zwraca statusy i dostępność wszystkich modułów.
 *
 * @response 200 {"data": {"modules": [...]}}
 */
class ModulesAction extends Controller
{
    public function __construct(protected ModuleSettings $moduleSettings)
    {

    }
    /**
     * Zwraca statusy wszystkich modułów gamifikacji.
     *
     * @response 200 {"data": {"modules": [...]}}
     */
    public function __invoke()
    {
        return Response::success(data: [
            'modules' => $this->moduleSettings->listStatusModules()
        ]);
    }
}
