<?php

namespace Albedo\Gamification\Traits;

use Illuminate\Support\Collection;

trait UtilityEnum {

    use UtilityFilamentEnum;

    public static function casesCollection(): Collection
    {
        return collect(self::cases());
    }

    public static function labels(): array
    {
        return self::casesCollection()
            ->mapWithKeys(fn($case) => [$case->value => $case->label()])
            ->toArray();
    }

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    public static function names(): array
    {
        return array_column(self::cases(), 'name');
    }

    public static function nameCombine(): array
    {
        return array_combine(self::names(), self::names());
    }

    public static function valueCombine(): array
    {
        return array_combine(self::values(), self::values());
    }

    public static function collection(): Collection
    {
        return self::casesCollection()
            ->map(fn($case) => [
                'id' => $case->value,
                'name' => $case->label()
            ]);
    }

    public static function findByValue(mixed $value): ?self
    {
        return self::casesCollection()
            ->first(fn($case) => $case->value === $value);
    }

    public static function findByName(string $name): ?self
    {
        return self::casesCollection()
            ->first(fn($case) => $case->name === $name);
    }

    public function is(self $other): bool
    {
        return $this->value === $other->value;
    }
}
