<?php

namespace Albedo\Gamification\Services;

use Albedo\Gamification\Dtos\PointDto;
use Albedo\Gamification\Events\PointsAwardedEvent;
use Albedo\Gamification\Events\PointsUpdatedEvent;
use Albedo\Gamification\Models\Point;
use Albedo\Gamification\Models\PointPeriod;
use Illuminate\Database\Eloquent\Model;

class PointService
{
    public function awardPoints(PointDto $pointDto): Point
    {
        $point = Point::query()->lockForUpdate()->firstOrCreate([
            'user_id' => $pointDto->getUser()->getKey(),
            'point_type_id' => $pointDto->getPointType()->getKey(),
            'receiver_id' => $pointDto->getReceiver()->getKey(),
            'receiver_type' => $pointDto->getReceiver()->getMorphClass(),
            'activity_id' => $pointDto->getActivity()?->getKey(),
            'activity_type' => $pointDto->getActivity()?->getMorphClass(),
            'comment' => $pointDto->getComment(),
            'points' => $pointDto->getPoints(),
        ]);

        event(new PointsAwardedEvent($point));

        return $point;
    }

    public static function awardOrUpdatePoints(PointDto $pointDto): Point
    {
        $point = Point::updateOrCreate([
            'user_id' => $pointDto->getUser()->getKey(),
            'point_type_id' => $pointDto->getPointType()->getKey(),
            'receiver_id' => $pointDto->getReceiver()->getKey(),
            'receiver_type' => $pointDto->getReceiver()->getMorphClass(),
            'activity_id' => $pointDto->getActivity()?->getKey(),
            'activity_type' => $pointDto->getActivity()?->getMorphClass(),
        ], [
            'comment' => $pointDto->getComment(),
            'points' => $pointDto->getPoints(),
        ]);


        if ($point->wasRecentlyCreated) {
            event(new PointsAwardedEvent($point));
        } else {
            event(new PointsUpdatedEvent($point));
        }

        return $point;
    }

}
