<?php

namespace Albedo\Gamification\Models\Traits;

use Albedo\Gamification\Models\Point;
use Illuminate\Database\Eloquent\Relations\MorphMany;

trait PointableTrait
{
    public function points(): MorphMany
    {
        return $this->morphMany(Point::class, Point::MORPH_NAME_ACTIVITY);
    }

    public function calculateUserPoints()
    {
        return $this->points()->where('receiver_type', config('gamification.user_model'))->sum('points');
    }

}
