<?php

namespace Albedo\Gamification\Http\Resources;

use Albedo\Gamification\Models\Faq;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin Faq */
class FaqResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'items' => $this->whenLoaded('faqItems', FaqItemResource::collection($this->faqItems))
        ];
    }
}
