<?php

namespace Albedo\Gamification\Http\Resources;

use Albedo\Gamification\Models\Avatar;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin Avatar */
class AvatarResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->getFirstMediaUrl('avatar') ?? '#!',
        ];
    }
}
