<?php

namespace Albedo\Gamification\Database\Seeders;

use Albedo\Gamification\Models\FileType;
use Illuminate\Database\Seeder;

class FileTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        collect([
            'data_processing_policy' => 'Polityka przetwarzania danych',
            'policy_privacy' => 'Polityka prywatności',
            'rule' => 'Regulamin',
            'rule_attachment' => 'Załącznik do regulaminu',
            'personal_data' => 'Dane osobowe',
            'cookies_policy' => 'Polityka plików cookie',
            'marketing_data_policy' => 'Polityka danych marketingowych',
        ])->each(function ($name, $slug) {
            FileType::updateOrCreate([
                'slug' => $slug,
            ], [
                'name' => $name,
            ]);
        });
    }
}
