<?php

use function Pest\Laravel\get;
use function Pest\Laravel\getJson;

it('returns module settings correctly', function () {
    get(route('gamification.module-settings'))
        ->assertOk()
        ->assertJsonStructure([
            'status',
            'data' => [
                'plugEnabled',
                'plugContent',
                'registrationEnabled',
                'elearningEnabled',
                'duelEnabled',
                'specialMissionEnabled',
                'questionnaireEnabled',
            ],
            'meta',
            'message',
            'errors',
        ])
        ->assertJson([
            'status' => 'OK',
            'data' => [
                'plugEnabled' => true,
                'plugContent' => 'Test',
                'registrationEnabled' => true,
                'elearningEnabled' => true,
                'duelEnabled' => true,
                'specialMissionEnabled' => true,
                'questionnaireEnabled' => true,
            ],
        ]);
});
