<?php

namespace Albedo\Gamification\Filament;

use Albedo\Gamification\Filament\Agreements\AgreementResource;
use Albedo\Gamification\Filament\Pages\ManageModuleSettings;
use Filament\Contracts\Plugin;
use Filament\Panel;

class GamificationPlugin implements Plugin
{
    public function getId(): string
    {
        return 'gamification';
    }

    public function register(Panel $panel): void
    {
        $panel
            ->resources([
                AgreementResource::class,
            ])
            ->pages([
                ManageModuleSettings::class
            ]);
    }

    public function boot(Panel $panel): void
    {
        //
    }

    public static function make(): static
    {
        return app(static::class);
    }
}
