<?php

namespace Albedo\Gamification\Models\Traits;

use Albedo\Gamification\Contracts\PeriodContract;
use Illuminate\Support\Carbon;

trait ActivityPeriodTrait
{
    public function getDateForPeriod(): Carbon
    {
        return $this->created_at;
    }
    public function getPeriodOfClass(string $periodClass): ?PeriodContract
    {
        return $this->getPeriodByClass($periodClass)::getPeriodByDate($this->getDateForPeriod());
    }

    public function getPeriodOfClassOrNull(string $periodClass): ?PeriodContract
    {
        return $this->getPeriodByClass($periodClass)::getPeriodByDateOrNull($this->getDateForPeriod());
    }

    protected function getPeriodByClass($periodClass): ?PeriodContract
    {
        return app($periodClass);
    }
}
