<?php

namespace Albedo\Gamification\Filament\Agreements\Schemas;

use Filament\Forms\Components\Radio;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;

class AgreementForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('name')
                    ->label('Name IT')
                    ->required()
                    ->maxLength(255),
                TextInput::make('label')
                    ->label('Name draft')
                    ->required()
                    ->maxLength(255),
                Textarea::make('text')
                    ->required(),
                Radio::make('required')
                    ->options([
                        0 => 'No',
                        1 => 'Yes',
                    ]),
            ]);
    }
}
