<?php

namespace Albedo\Gamification\Services;

use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Http\Request;
use Albedo\Gamification\Models\Agreement;
use Albedo\Gamification\Models\UserAgreement;

class GamificationAgreementHandler
{
    public static function handleAgreements(Authenticatable $user, Request $request): void
    {
        $agreements = Agreement::all();

        $agreements->each(fn(Agreement $agreement) => UserAgreement::create([
            'agreement_id' => $agreement->id,
            'user_id' => $user->id,
            'accepted' => (bool)$request->input($agreement->getAgreementKey(), false)
        ]));
    }
}
