<?php

namespace Albedo\Gamification\Tests\Feature;

use Albedo\Gamification\Models\Agreement;
use Albedo\Gamification\Models\UserAgreement;
use Albedo\Gamification\Services\GamificationAgreementHandler;
use Illuminate\Http\Request;
use function Pest\Laravel\getJson;


it('should return agreements list', function () {

    Agreement::create([
        'name' => 'Test',
        'label' => 'Test',
        'required' => 1,
        'text' => 'test',
    ]);

    getJson(route('gamification.agreements'))
        ->assertStatus(200);
});


it('register with agreements - saves UserAgreements', function () {

    $user = \Albedo\Gamification\Tests\Models\User::factory()->create();

    $agreement1 = Agreement::create(['name' => 'regulations', 'required' => 1,'label' => 'Regulamin']);
    $agreement2 = Agreement::create(['name' => 'privacy_policy', 'required' => 0,'label' => 'Polityka prywatności']);

    $data = [
        'first_name' => 'Jan',
        'last_name' => 'Kowalski',
        'email' => 'j.kowalski@albedomarketing.pl',
        'email_confirmation' => 'j.kowalski@albedomarketing.pl',
        'password' => 'password123!',
        'password_confirmation' => 'password123!',
        'phone_number' => '123456789',
        'avatar_id' => 1,
        $agreement1->getAgreementKey() => true,
        $agreement2->getAgreementKey() => false,
    ];

    GamificationAgreementHandler::handleAgreements($user, new Request($data));

    expect(UserAgreement::where('user_id', $user->id)->where('agreement_id',$agreement1->id)->first()->accepted)->toBeTrue();
    expect(UserAgreement::where('user_id', $user->id)->where('agreement_id',$agreement2->id)->first()->accepted)->toBeFalse();
});
