<?php

use Albedo\Gamification\Models\PointCategory;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('points', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(config('gamification.user_model'))->nullable();
            $table->foreignIdFor(PointCategory::class)->constrained();
            $table->morphs('receiver');
            $table->nullableMorphs('activity');
            $table->decimal('points');
            $table->string('comment')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('points');
    }
};
