<?php

namespace Albedo\Gamification\Filament\Pages;

use Albedo\Gamification\Settings\ModuleSettings;
use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;

class ManageModuleSettings extends SettingsPage
{
    protected static ?string $navigationIcon = 'heroicon-o-cog-6-tooth';

    protected static string $settings = ModuleSettings::class;

    protected static ?string $title = 'Moduły';

    protected static ?string $navigationGroup = 'Ustawienia Grywalizacji ';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                DateTimePicker::make('registration_start_date')
                    ->label('Data rozpoczęcia rejestracji'),
                DateTimePicker::make('registration_end_date')
                    ->label('Data zakończenia rejestracji'),
                DateTimePicker::make('login_start_date')
                    ->label('Data rozpoczęcia logowania'),
                DateTimePicker::make('login_end_date')
                    ->label('Data zakończenia logowania'),
                DateTimePicker::make('plug_visible_start_date')
                    ->label('Data widoczności wtyczki - początek'),
                DateTimePicker::make('plug_visible_end_date')
                    ->label('Data widoczności wtyczki - koniec'),
                TextInput::make('plug_visible_text')
                    ->label('Tekst widoczności wtyczki'),
                Toggle::make('gamification_inactive_placeholder_enabled')
                    ->label('Włącz zaślepkę nieaktywnej grywalizacji'),
                TextInput::make('gamification_inactive_placeholder_text')
                    ->label('Tekst zaślepki nieaktywnej grywalizacji'),
                DateTimePicker::make('program_before_plug_visible_date')
                    ->label('Data widoczności wtyczki przed programem'),
                TextInput::make('program_before_plug_visible_text')
                    ->label('Tekst wtyczki przed programem'),
                DateTimePicker::make('program_after_plug_visible_date')
                    ->label('Data widoczności wtyczki po programie'),
                TextInput::make('program_after_plug_visible_text')
                    ->label('Tekst wtyczki po programie'),
            ]);
    }
}

