<?php

use Albedo\Gamification\Services\AgreementService;
use Albedo\Gamification\Services\GamificationAgreementHandler;
use Albedo\Gamification\Models\Agreement;
use Illuminate\Http\Request;
use Illuminate\Foundation\Testing\RefreshDatabase;

describe('GamificationAgreementHandler', function () {

    uses(RefreshDatabase::class);

    it('zapisuje poprawne zgody użytkownika do bazy', function () {
        $agreement1 = Agreement::create(['name' => 'rodo', 'label' => 'RODO', 'required' => 1, 'text' => '...']);
        $agreement2 = Agreement::create(['name' => 'newsletter', 'label' => 'Newsletter', 'required' => 0, 'text' => '...']);

        $user = \Albedo\Auth\Tests\Models\User::factory()->create();

        $request = new Request(AgreementService::prepareAgreementsList()->pluck('required', 'key')->toArray());

        $handler = new GamificationAgreementHandler();
        $handler->handleAgreements($user, $request);

        $this->assertDatabaseHas('user_agreements', [
            'user_id' => $user->id,
            'name' => 'rodo',
            'accepted' => true,
        ]);
        $this->assertDatabaseHas('user_agreements', [
            'user_id' => $user->id,
            'name' => 'newsletter',
            'accepted' => false,
        ]);
    });
});
