<?php

namespace Albedo\Gamification\Providers;

use Faker\Provider\Base;
use Ramsey\Uuid\Uuid;

class ImageGeneratorProvider extends Base
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }


    public static function image(int $width = 640, int $height = 480)
    {
        $path = storage_path() . DIRECTORY_SEPARATOR . 'app' . DIRECTORY_SEPARATOR . Uuid::uuid1() . '.png';
        $im = imagecreate($width, $height);

        imagecolorallocate($im, rand(0, 255), rand(0, 255), rand(0, 255));
        imagepng($im, $path);

        return $path;
    }
}
