<?php

namespace Albedo\Gamification\Models;

use Albedo\Auth\Models\Traits\HasVerification;
use Albedo\Gamification\Contracts\HasAvatar;
use Albedo\Gamification\Models\Traits\HasUserAvatar;
use Albedo\Notification\Traits\HasFCMToken;
use Albedo\Notification\Traits\HasNotification;
use Albedo\Questionnaire\Contracts\QuestionnaireUserExportable;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable implements HasAvatar
{
    use HasFactory,
        HasApiTokens,
        HasRoles,
        HasVerification,
        SoftDeletes,
        Notifiable,
        HasFCMToken,
        HasUserAvatar;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'first_name',
        'last_name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    public function fullName(): Attribute
    {
        return Attribute::make(
            get: fn() => "{$this->first_name} {$this->last_name}",
        );
    }

}
