<?php

namespace Albedo\Gamification\Models\Traits;

use Albedo\Gamification\Models\Agreement;
use Albedo\Gamification\Models\UserAgreement;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

trait HasUserAgreements
{
    public function agreements(): BelongsToMany
    {
        return $this->belongsToMany(Agreement::class, 'user_agreements', 'user_id', 'agreement_id');
    }

    public function userAgreements(): HasMany
    {
        return $this->hasMany(UserAgreement::class, 'user_id');
    }

    public function hasAcceptedAgreement(string $name): bool
    {
        return $this->userAgreements()->where('name', $name)->where('accepted', 1)->exists();
    }
}
