<?php

namespace Albedo\Gamification\Models;

use Albedo\Gamification\Models\ActivityCentre;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ActivityTargetUserStatus extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $fillable = [
        'activity_centre_id',
        'read_at',
    ];

    public function activityCentre(): BelongsTo
    {
        return $this->belongsTo(ActivityCentre::class);
    }
}
