<?php

namespace Albedo\Gamification\Models;

use Albedo\Gamification\Models\ActivityTargetUserStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class ActivityTarget extends Model
{
    use HasFactory;

    const TARGETABLE = 'targetable';

    public $timestamps = false;

    protected $fillable = [
        'activity_centre_id',
        'targetable_type',
        'targetable_id'
    ];

    public function targetable(): MorphTo
    {
        return $this->morphTo(self::TARGETABLE);
    }

    public function activityCentre(): BelongsTo
    {
        return $this->belongsTo(ActivityCentre::class);
    }

    public function activityTargetUserStatuses(): HasMany
    {
        return $this->hasMany(ActivityTargetUserStatus::class);
    }

}
