<?php

namespace Albedo\Gamification\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class ActivityCentre extends Model
{
    use HasFactory;

    const ACTIVITYABLE = 'activityable';

    protected $fillable = [
        'type',
        'activityable_type',
        'activityable_id',
        'body',
        'title',
        'data',
    ];

    protected function casts(): array
    {
        return [
            'data' => 'array',
        ];
    }

    public function activityable(): MorphTo
    {
        return $this->morphTo(self::ACTIVITYABLE);
    }

    public function activityTargets(): HasMany
    {
        return $this->hasMany(ActivityTarget::class);
    }
}
