<?php

namespace Albedo\Gamification\Listeners;

use Albedo\Gamification\Data\ActivityCentreData;
use Albedo\Gamification\Data\AvatarData;
use Albedo\Gamification\Services\ActivityCentreService;
use Illuminate\Notifications\Notification;

class CreateActivityFromNotificationListener
{
    public function __construct(public ActivityCentreService $activityCentreService)
    {
    }

    public function handle($event): void
    {
        $notification = $event->notification;

        if (!$notification instanceof Notification) {
            return;
        }

        $activity = $this->activityCentreService::updateOrCreateActivity(new ActivityCentreData(
            type: 'notification',
            title: $event->news->title,
            body: $event->news->content,
        ));

        // TODO notifable??
        $this->activityCentreService::createTarget($activity, $notification->notifable);
    }
}
