<?php

namespace Albedo\Gamification\Listeners;

use Albedo\Gamification\Data\ActivityableReferenceData;
use Albedo\Gamification\Data\ActivityCentreData;
use Albedo\Gamification\Data\AvatarData;
use Albedo\Gamification\Data\IconData;
use Albedo\Gamification\Models\News;
use Albedo\Gamification\Services\ActivityCentreService;

class CreateActivityFromNewsListener
{
    public function __construct(public ActivityCentreService $activityCentreService)
    {
    }

    public function handle($event): void
    {
        $news = $event->news;

        if (!$news instanceof News) {
            return;
        }

        $activity = $this->activityCentreService::updateOrCreateActivity(new ActivityCentreData(
            type: 'news',
            title: $event->news->title,
            body: $event->news->content,
            data: [
                new AvatarData('system', url('default-avatar.svg'), 'attention'),
            ],
            activityableReferenceData: new ActivityableReferenceData(
                $news->getMorphClass(),
                $news->getKey()
            )
        ));

        if ($news->roles->isEmpty()) {
            $this->activityCentreService::toEveryone($activity);
        } else {
            foreach ($news->roles as $role) {
                $this->activityCentreService::createTarget($activity, $role);
            }
        }
    }
}
