<?php

namespace Albedo\Gamification\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ActivityCenterReadRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'ids' => ['sometimes', 'array'],
            'ids.*' => ['integer'],
            'type' => ['nullable', Rule::in(['message', 'news', 'notification'])],
        ];
    }

    protected function prepareForValidation(): void
    {
        if (is_int($this->ids)) {
            $this->merge([
                'ids' => [$this->ids],
            ]);
        }

        if (is_null($this->ids)) {
            $this->merge([
                'ids' => [],
            ]);
        }

        if (is_string($this->ids)) {
            $this->merge([
                'type' => $this->ids,
                'ids' => null,
            ]);
        }
    }

    public function authorize(): bool
    {
        return true;
    }
}
