<?php

namespace Albedo\Gamification\Http\Controllers;

use Albedo\Gamification\Http\Resources\NewsResource;
use Albedo\Gamification\Models\News;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;
use Knuckles\Scribe\Attributes\Endpoint;
use Knuckles\Scribe\Attributes\Group;
use Knuckles\Scribe\Attributes\ResponseFromFile;

#[Group('Aktualności')]
class DashboardNewsController extends Controller
{
    #[Endpoint(title: 'Aktualność na stonę główną', description: 'Zwraca jedną aktualność na stonę główną', authenticated: true)]
    #[ResponseFromFile('storage/api-responses/News/dashboard.200.json', status: 200, description: 'Poprawna odpowiedź')]
    public function __invoke(Request $request): JsonResponse
    {
        $user = Auth::user();
        $user->load('roles');

        $news = News::with(['media'])
            ->where('start_at', '<=', now())
            ->where(fn($q) => $q->where('end_at', '>=', now())->orWhereNull('end_at'))
            ->where(fn($q) => $q
                ->whereHas('roles', fn($q) => $q->whereIn('name', $user->roles->pluck('name')->toArray()))
                ->orWhereDoesntHave('roles'))
            ->where('for_dashboard', true)
            ->orderByDesc('created_at')
            ->first();

        return Response::success(
            data: $news ? new NewsResource($news): null,
        );
    }
}
