<?php

namespace Albedo\Gamification\Http\Controllers;

use Albedo\Gamification\Http\Resources\ProgramFilesResource;
use Albedo\Gamification\Models\ProgramFile;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Storage;
use Illuminate\Validation\ValidationException;

/**
 * Pobierz zawartość pliku programu w htmlu (załącznika).
 *
 * Endpoint zwracający zawartość pliku html powiązanego z programem.
 */
class AttachmentHtmlAction
{
    /**
     * Zwraca zawartość pliku programu
     */
    public function __invoke(string $slug)
    {
        $programFile = ProgramFile::with(['media', 'fileType'])
            ->whereHas('fileType', function ($query) use ($slug) {
                return $query->where('slug', $slug);
            })
            ->first();

        if ($programFile) {

            $file = $programFile->getLastMedia('rule_html')?->getPath();

            if ($file && file_exists($file)) {
                $mimeType = File::mimeType($file);
                return response(file_get_contents($file))->header('Content-Type', $mimeType);
            }

        }

        throw ValidationException::withMessages([
            'slug' => [__('File doesn\'t exists.')],
        ]);
    }
}
