<?php

namespace Albedo\Gamification\Http\Controllers;

use Albedo\Gamification\Data\ActivityCentreData;
use Albedo\Gamification\Data\AvatarData;
use Albedo\Gamification\Http\Requests\ActivityCenterReadRequest;
use Albedo\Gamification\Models\ActivityCentre;
use Albedo\Gamification\Models\ActivityTarget;
use Albedo\Gamification\Services\ActivityCentreService;
use App\Http\Controllers\Controller;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Auth\AuthenticationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;

class ActivityCenterReadAction extends Controller
{
    public function __construct(public ActivityCentreService $activityCentreService)
    {

    }

    /**
     * @throws AuthenticationException
     */
    public function __invoke(ActivityCenterReadRequest $request)
    {
        $user = auth()->user();

        if (is_null($user)) {
            throw new AuthenticationException();
        }

        $ids = $request->input('ids');

        match (true) {
            is_array($ids) => $this->activityCentreService->readUserActivityTargets($user, $ids),
            is_int($ids) => $this->activityCentreService->readUserActivityTargets($user, [$ids]),
            is_null($ids) => $this->activityCentreService->readUserActivityTargets($user, []),
            in_array($ids, ['notification', 'message', 'news']) => $this->activityCentreService->readUserActivityTargets($user, $this->activityCentreService->unreadUserActivities($user, $ids)->pluck('id')->toArray()),
        };

        return Response::success(message: __('Read successfully'));
    }
}
