<?php

namespace Albedo\Gamification\Http\Controllers;

use Albedo\Gamification\Data\ActivityCentreData;
use Albedo\Gamification\Data\AvatarData;
use Albedo\Gamification\Models\ActivityCentre;
use Albedo\Gamification\Models\ActivityTarget;
use Albedo\Gamification\Services\ActivityCentreService;
use App\Http\Controllers\Controller;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Auth\AuthenticationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;

class ActivityCenterAction extends Controller
{
    public function __construct(public ActivityCentreService $activityCentreService)
    {

    }

    /**
     * @throws AuthenticationException
     */
    public function __invoke(Request $request)
    {
        $user = auth()->user();

        if (is_null($user)) {
            throw new AuthenticationException();
        }

        $type = $request->input('type');
        $limit = min(request()->integer('per_page', $request->limit),50);

        $result = $this->activityCentreService->getUserActivities($user, $type, $limit);

        return Response::success(data: $result);
    }
}
