<?php

namespace Albedo\Gamification\Filament\Rules;

use Albedo\Gamification\Filament\Rules\Pages\CreateRule;
use Albedo\Gamification\Filament\Rules\Pages\EditRule;
use Albedo\Gamification\Filament\Rules\Pages\ListRules;
use Albedo\Gamification\Filament\Rules\Pages\ViewRule;
use Albedo\Gamification\Filament\Rules\Schemas\RulesForm;
use Albedo\Gamification\Filament\Rules\Schemas\RulesInfolist;
use Albedo\Gamification\Filament\Rules\Tables\RulesTable;
use Albedo\Gamification\Models\Rule;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class RuleResource extends Resource
{
    protected static ?string $model = Rule::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedDocumentCurrencyRupee;

    protected static string|null|\UnitEnum $navigationGroup = "Gamification";

    public static function form(Schema $schema): Schema
    {
        return RulesForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return RulesInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return RulesTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListRules::route('/'),
            'create' => CreateRule::route('/create'),
            'view' => ViewRule::route('/{record}'),
            'edit' => EditRule::route('/{record}/edit'),
        ];
    }
}
