<?php

namespace Albedo\Gamification\Filament\News\Schemas;

use Albedo\Gamification\Models\News;
use Filament\Infolists\Components\IconEntry;
use Filament\Infolists\Components\SpatieMediaLibraryImageEntry;
use Filament\Infolists\Components\TextEntry;
use Filament\Schemas\Schema;

class NewsInfolist
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextEntry::make('admin_id')
                    ->label('Author')
                    ->formatStateUsing(fn(News $record) => $record->admin->full_name),
                TextEntry::make('title'),
                TextEntry::make('short_description'),
                TextEntry::make('content'),
                TextEntry::make('start_at')
                    ->dateTime(),
                TextEntry::make('end_at')
                    ->dateTime(),
                TextEntry::make('url'),
                TextEntry::make('action_name'),
                TextEntry::make('created_at')
                    ->dateTime(),
                TextEntry::make('updated_at')
                    ->dateTime(),
                IconEntry::make('for_dashboard')
                    ->boolean(),
                TextEntry::make('roles.name')
                    ->label('Roles')
                    ->tooltip('Only these roles can view this news'),
                SpatieMediaLibraryImageEntry::make('images')
                    ->collection('news')
                    ->square()
                    ->label('Images')
                    ->columnSpanFull(),
            ]);
    }
}
