<?php

namespace Albedo\Gamification\Filament\News\Schemas;

use Filament\Forms\Components\DateTimePicker;
use Filament\Forms\Components\Radio;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Schemas\Components\Utilities\Get;
use Filament\Schemas\Components\Utilities\Set;
use Filament\Schemas\Schema;

class NewsForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                TextInput::make('title')
                    ->required(),
                TextInput::make('short_description')
                    ->required(),
                RichEditor::make('content')
                    ->required()
                    ->columnSpanFull()
                    ->lazy()
                    ->afterStateUpdated(function ($state, Get $get, Set $set) {
                        if (!$get('short_description')) {
                            $set('short_description', mb_substr(strip_tags($state), 0, 150));
                        }
                    }),
                DateTimePicker::make('start_at')
                    ->required(),
                DateTimePicker::make('end_at'),
                TextInput::make('url'),
                TextInput::make('action_name'),
                Select::make('role_id')
                    ->multiple()
                    ->preload()
                    ->relationship('roles', 'name')
                    ->hint('Visible only to these roles')
                    ->label('Roles')
                    ->columnSpanFull(),
                Toggle::make('for_dashboard'),
                Toggle::make('published')->columnSpanFull(),
                SpatieMediaLibraryFileUpload::make('images')
                    ->multiple()
                    ->collection('news')
                    ->disk('public')
                    ->reorderable()
                    ->maxFiles(20)
                    ->image()
                    ->columnSpanFull()
            ]);
    }
}
