<?php

namespace Albedo\Gamification\Filament\News\Pages;

use Albedo\Gamification\Filament\News\NewsResource;
use Albedo\Gamification\Models\News;
use Filament\Actions\DeleteAction;
use Filament\Actions\ViewAction;
use Filament\Resources\Pages\EditRecord;

class EditNews extends EditRecord
{
    protected static string $resource = NewsResource::class;

    protected function getHeaderActions(): array
    {
        return [
            ViewAction::make(),
            DeleteAction::make()
                ->before(fn(News $record) => $record->roles()->detach()),
        ];
    }
}
