<?php

namespace Albedo\Gamification\Filament\News;

use Albedo\Gamification\Filament\News\Pages\CreateNews;
use Albedo\Gamification\Filament\News\Pages\EditNews;
use Albedo\Gamification\Filament\News\Pages\ListNews;
use Albedo\Gamification\Filament\News\Pages\ViewNews;
use Albedo\Gamification\Filament\News\Schemas\NewsForm;
use Albedo\Gamification\Filament\News\Schemas\NewsInfolist;
use Albedo\Gamification\Filament\News\Tables\NewsTable;
use Albedo\Gamification\Models\News;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class NewsResource extends Resource
{
    protected static ?string $model = News::class;

    protected static string|null|\UnitEnum $navigationGroup = "Gamification";

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedNewspaper;
    protected static ?string $label = 'News';
    protected static ?string $pluralLabel = 'News';

    public static function form(Schema $schema): Schema
    {
        return NewsForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return NewsInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return NewsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListNews::route('/'),
            'create' => CreateNews::route('/create'),
            'view' => ViewNews::route('/{record}'),
            'edit' => EditNews::route('/{record}/edit'),
        ];
    }
}
