<?php

namespace Albedo\Gamification\Filament;

use Albedo\Gamification\Filament\Agreements\AgreementResource;
use Albedo\Gamification\Filament\Attachments\AttachmentResource;
use Albedo\Gamification\Filament\Avatars\AvatarResource;
use Albedo\Gamification\Filament\Faqs\FaqResource;
use Albedo\Gamification\Filament\News\NewsResource;
use Albedo\Gamification\Filament\Pages\ManageModuleSettings;
use Albedo\Gamification\Filament\Rules\RuleResource;
use Filament\Contracts\Plugin;
use Filament\Panel;

class GamificationPlugin implements Plugin
{
    public function getId(): string
    {
        return 'gamification';
    }

    public function register(Panel $panel): void
    {
        $panel
            ->resources([
                AgreementResource::class,
                AttachmentResource::class,
                AvatarResource::class,
                RuleResource::class,
                FaqResource::class,
                NewsResource::class,
            ])
            ->pages([
                ManageModuleSettings::class
            ]);
    }

    public function boot(Panel $panel): void
    {
        //
    }

    public static function make(): static
    {
        return app(static::class);
    }
}
