<?php

namespace Albedo\Gamification\Filament\Faqs;

use Albedo\Gamification\Models\Faq;
use Albedo\Gamification\Filament\Faqs\Pages\CreateFaq;
use Albedo\Gamification\Filament\Faqs\Pages\EditFaq;
use Albedo\Gamification\Filament\Faqs\Pages\ListFaqs;
use Albedo\Gamification\Filament\Faqs\Pages\ViewFaq;
use Albedo\Gamification\Filament\Faqs\Schemas\FaqForm;
use Albedo\Gamification\Filament\Faqs\Schemas\FaqInfolist;
use Albedo\Gamification\Filament\Faqs\Tables\FaqsTable;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class FaqResource extends Resource
{
    protected static ?string $model = Faq::class;

    protected static string|null|\UnitEnum $navigationGroup = "Gamification";

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedQuestionMarkCircle;

    public static function form(Schema $schema): Schema
    {
        return FaqForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return FaqInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return FaqsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListFaqs::route('/'),
            'create' => CreateFaq::route('/create'),
            'view' => ViewFaq::route('/{record}'),
            'edit' => EditFaq::route('/{record}/edit'),
        ];
    }

    public static function getRecordRouteBindingEloquentQuery(): Builder
    {
        return parent::getRecordRouteBindingEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
