<?php

namespace Albedo\Gamification\Filament\Avatars\Schemas;

use Filament\Forms\Components\Hidden;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Filament\Schemas\Schema;
use Illuminate\Support\Str;

class AvatarForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                SpatieMediaLibraryFileUpload::make("avatar")
                    ->validationMessages([
                        'required' => 'Awatar jest wymagany',
                    ])->collection('avatar')
                    ->label('Awatar')
                    ->preserveFilenames()
                    ->disk('public'),
                Hidden::make('name')
                    ->default(fn() => Str::uuid()->toString()),
            ]);
    }
}
