<?php

namespace Albedo\Gamification\Data;

use Spatie\LaravelData\Data;

class ActivityCentreData extends Data {

    public function __construct(
        public string $type,
        public string $title,
        public string $body,
        public array $data = [],
        public ?ActivityableReferenceData $activityableReferenceData = null,
    )
    {
    }

    public function toArray(): array
    {
        return [
            'type' => $this->type,
            'title' => $this->title,
            'body' => $this->body,
            'data' => $this->data,
        ];
    }
}
