<?php

namespace Albedo\Gamification\Database\Seeders;

use Albedo\Gamification\Data\ActivityCentreData;
use Albedo\Gamification\Models\ActivityCentre;
use Albedo\Gamification\Services\ActivityCentreService;
use Albedo\Gamification\Tests\Models\User;
use Albedo\Notification\Notification;
use Illuminate\Database\Seeder;

class ActivityCentreSeeder extends Seeder
{
    public function run(): void
    {
        $user = User::first();

        $activity = ActivityCentreService::updateOrCreateActivity(new ActivityCentreData(
            type: 'notification',
            title: 'Xxxx xxxxx xxxxxxxx',
            body: 'Xxxxx <b>xxx xxx</b> xxxxxx xxxxxx x xxxx',
            data: [
                'avatar' => [
                    'id' => 1,
                    'name' => 'https://xxx.xx'
                ],
                'icon' => 'bell'
            ]
        ));

        ActivityCentreService::createTarget($activity, $user);

    }
}
