<?php

use Albedo\Gamification\Models\ActivityCentre;
use Albedo\Gamification\Models\ActivityTarget;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('activity_target_user_statuses', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(config('gamification.user_model'))->constrained();
            $table->foreignIdFor(ActivityTarget::class)->constrained();
            $table->timestamp('read_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('activity_target_user_statuses');
    }
};
