<?php

use Albedo\Gamification\Models\ActivityCentre;
use Albedo\Gamification\Models\ActivityTarget;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Spatie\Activitylog\Models\Activity;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('activity_targets', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(ActivityCentre::class)->constrained();
            $table->nullableMorphs('targetable');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('activity_targets');
    }
};
