<?php

namespace Albedo\Gamification\Database\Factories;

use Albedo\Gamification\Models\News;
use Albedo\Gamification\Providers\ImageGeneratorProvider;
use Illuminate\Database\Eloquent\Factories\Factory;
use Spatie\Permission\Models\Role;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\News>
 */
class NewsFactory extends Factory
{

    protected $model = News::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'title' => $this->faker->sentence(),
            'short_description' => $this->faker->sentence(),
            'content' => $this->faker->randomHtml(),
            'start_at' => $this->faker->dateTimeBetween('-2 months', '+ 1 months'),
            'published' => $this->faker->boolean(),
            'url' => $this->faker->url(),
            'for_dashboard' => $this->faker->boolean(),
        ];
    }

    public function configure(): Factory
    {
        return $this->afterCreating(function (News $news) {
            $roles = Role::take(1, 3)
                ->get();
            $news->roles()
                ->sync($roles);

            for ($i = 1; $i <= rand(1, 4); $i++) {
                $news->addMedia(ImageGeneratorProvider::image())
                    ->toMediaCollection('news', 'public');
            }
        });
    }
}
