<?php

return [

    'user_model' => App\Models\User::class,

    'route' => [
        'as' => 'gamification.',
        'prefix' => 'api',
        'middleware' => [
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
            'auth:sanctum'
        ],
    ],

    'default_content_provider' =>  Albedo\Gamification\Providers\Fakers\AnimalFakerProvider::class,
                                 // Albedo\Gamification\Providers\Fakers\XxxFakerProvider::class,

    'panel_access_email_domain' => env('PANEL_ACCESS_EMAIL_DOMAIN', '@albedomarketing.pl'),

    'panel_access_requires_verified_email' => env('PANEL_ACCESS_REQUIRES_VERIFIED_EMAIL', true),

    'panel_access_requires_2fa' => env('PANEL_ACCESS_REQUIRES_2FA', true),
];
