<?php

namespace Albedo\Gamification\Tests;

use Illuminate\Foundation\Testing\TestCase as BaseTestCase;
use Orchestra\Testbench\TestCase as Orchestra;

abstract class TestCase extends Orchestra
{

    protected function getPackageProviders($app): array
    {
        return [
            \Albedo\Gamification\GamificationServiceProvider::class,
        ];
    }

    protected function setUp(): void
    {
        parent::setUp();

        $this->loadMigrationsFrom(__DIR__ . '/database/migrations');
    }

    protected function getEnvironmentSetUp($app)
    {
        $app['config']->set('albedo-auth.user_model', \Albedo\Auth\Tests\Models\User::class);
        $app['config']->set('gamification.user_model', \Albedo\Auth\Tests\Models\User::class);
        $app['config']->set('auth.providers.users.model', \Albedo\Auth\Tests\Models\User::class);
        $app['config']->set('auth.guards.api.driver', 'sanctum');
        $app['config']->set('auth.guards.api.provider', 'users');
        $app['config']->set('auth.guards.web.driver', 'session');
        $app['config']->set('gamification.user_model', \Albedo\Auth\Tests\Models\User::class);
    }

}


