<?php

namespace Albedo\Gamification\Services;

use Albedo\Gamification\Contracts\MustAcceptUserAgreements;
use Albedo\Gamification\Models\Agreement;
use Albedo\Gamification\Models\UserAgreement;

class AgreementService
{
    public static function prepareAgreementsList(): array
    {
        $agreements = Agreement::all();

        return $agreements->map(function (Agreement $agreement, $key) {
            return [
                'key' => $agreement->getAgreementKey(),
                'must_be_accepted' => $agreement->required,
                'text' => $agreement->parsed_text,
                'label' => $agreement->label,
            ];
        })
            ->toArray();
    }

    public function acceptAgreements(MustAcceptUserAgreements $user, array $data): void
    {
        Agreement::all()->each(function (Agreement $agreement) use ($user, $data) {
            $key = $agreement->getAgreementKey();

            if (array_key_exists($key, $data)) {
                UserAgreement::updateOrCreate([
                    'user_id' => $user->id,
                    'agreement_id' => $agreement->id,
                ], [
                    'accepted' => (bool)$data[$key]
                ]);
            }
        });
    }

    public function getAgreementRules(): array
    {
        $agreements = Agreement::all();

        return Agreement::all()
            ->mapWithKeys(fn(Agreement $agreement) => [
                $agreement->getAgreementKey() => [
                    'required',
                    $agreement->required ? 'accepted' : 'boolean'
                ]
            ])
            ->toArray();
    }
}
