<?php

namespace Albedo\Gamification\Models\Traits;

use Albedo\Gamification\Models\UserAgreement;
use Illuminate\Database\Eloquent\Relations\HasMany;

trait HasUserAgreements
{
    public function userAgreements(): HasMany
    {
        return $this->hasMany(UserAgreement::class, 'user_id');
    }

    public function hasAcceptedAgreement(string $name): bool
    {
        return $this->userAgreements()->where('name', $name)->where('accepted', 1)->exists();
    }
}
