<?php

namespace Albedo\Gamification;

use Illuminate\Support\Facades\Response;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;
use Illuminate\Support\Facades\Route;

class GamificationServiceProvider extends PackageServiceProvider
{
    public static string $name = 'gamification';

    public function configurePackage(Package $package): void
    {
        $package
            ->name(static::$name)
            ->hasMigrations([
                '2022_12_14_083707_create_settings_table',
                '2024_12_30_125323_create_documents_table',
                '2024_12_30_125406_create_agreements_table'
            ])
            ->runsMigrations()
            ->hasConfigFile('gamification')
            ->hasRoute('gamification');
    }

    public function boot()
    {
        $this->loadRoutesFrom(__DIR__.'/../routes/gamification.php');

        if (!Response::hasMacro('success')) {
            Response::macro('success', function (mixed $data = [], string $message = '', ?array $errors = null, mixed $meta = [], int $status = 200, array $headers = []) {
                $structure = [
                    'status' => __('OK'),
                    'data' => $data,
                    'meta' => $meta,
                    'message' => $message,
                    'errors' => $errors,
                ];

                return Response::json($structure, $status, $headers);
            });
        }

        if (!Response::hasMacro('error')) {
            Response::macro('error', function (mixed $data = [], string $message = '', mixed $meta = [], ?array $errors = null, int $status = 500, array $headers = []) {
                $structure = [
                    'status' => __('Error'),
                    'data' => $data,
                    'meta' => $meta,
                    'message' => $message,
                    'errors' => $errors,
                ];

                return Response::json($structure, $status, $headers);
            });
        }

        if (!Response::hasMacro('generalError')) {
            Response::macro('generalError', function (mixed $data = [], string $message = '', ?array $errors = null, mixed $meta = [], int $status = 500, array $headers = []) {
                $structure = [
                    'status' => __('Error'),
                    'data' => $data,
                    'meta' => $meta,
                    'message' => $message ?? __('An error occurred'),
                    'errors' => $errors,
                ];

                return Response::json($structure, $status, $headers);
            });
        }

    }
}
