<?php

namespace Albedo\Gamification\Filament\Agreements;

use Albedo\Gamification\Filament\Agreements\Pages\CreateAgreement;
use Albedo\Gamification\Filament\Agreements\Pages\EditAgreement;
use Albedo\Gamification\Filament\Agreements\Pages\ListAgreements;
use Albedo\Gamification\Filament\Agreements\Pages\ViewAgreement;
use Albedo\Gamification\Filament\Agreements\Schemas\AgreementForm;
use Albedo\Gamification\Filament\Agreements\Schemas\AgreementInfolist;
use Albedo\Gamification\Filament\Agreements\Tables\AgreementsTable;
use Albedo\Gamification\Models\Agreement;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class AgreementResource extends Resource
{
    protected static ?string $model = Agreement::class;


    protected static ?string $navigationLabel = 'Załączniki';

    protected static ?string $title = 'Moduły';


    protected static string|null|\UnitEnum $navigationGroup = 'Ustawienia';
    public static function form(Schema $schema): Schema
    {
        return AgreementForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return AgreementInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return AgreementsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListAgreements::route('/'),
            'create' => CreateAgreement::route('/create'),
            'view' => ViewAgreement::route('/{record}'),
            'edit' => EditAgreement::route('/{record}/edit'),
        ];
    }
}
